#ifndef __CSelectableMenuItem__
#define __CSelectableMenuItem__

#include <Basics/CHtmlString.hpp>
#include "CMenuItem.hpp"
using Exponent::Basics::CHtmlString;
using Exponent::GUI::Controls::CMenuItem;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CSelectableMenuItem CSelectableMenuItem.hpp
			 * @brief A representation of a menu item that can be checked or unchecked
			 *
			 * @date 12/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CSelectableMenuItem.hpp,v 1.7 2007/02/08 21:07:54 paul Exp $
			 */
			class CSelectableMenuItem : public CMenuItem
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================
				
				/**
				 * Construction
				 * @param text The string to display
				 * @param id The unique ID of this menu item
				 * @param selected True if item is selected, false otherwise
				 */
				CSelectableMenuItem(const CString &text, const long id, const bool selected = false);

				/**
				 * Destruction
				 */
				virtual ~CSelectableMenuItem();

//	===========================================================================
				
				/**
				 * Set the item selected
				 * @param selected True if the item is selected, false otherwise
				 */
				virtual void setSelected(const bool selected = true) { m_isSelected = selected; }
				
				/**
				 * Is the item selected
				 * @retval bool True if the item is selected, false otherwise
				 */
				virtual bool isSelected() const { return m_isSelected; }

				/**
				 * Set the unchecked image (other images are : normal(checked) rollover(rollover)
				 * @param unChecked The unchecked image
				 */
				virtual void setUnCheckedImage(IImage *unChecked) 
				{ 
					EXCHANGE_COUNTED_OBJECTS(m_unCheckedImage, unChecked);
				}

				/**
				 * Get the unchecked image
				 * @retval IImage* The unchecked image, may be NULL
				 */
				virtual IImage *getUnCheckedImage() const { return m_unCheckedImage; }

//	===========================================================================
				
			protected:

//	===========================================================================

				bool m_isSelected;					/**< is the item currently selected */
				IImage *m_unCheckedImage;		/**< the image to use to uncheck this */
			};
		}
	}
}
#endif	// End of CSelectableMenuItem.hpp